package gov.va.med.mhv.rxrefill.utils;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;

public class WebUtility {

	public static String dateToString(Date date, String format) {
		String stringDate = "";
		try {
			if (date != null) {
				SimpleDateFormat sdf = new SimpleDateFormat(format);
				stringDate = sdf.format(date);
			}
		} catch (Exception e) {
			throw new RuntimeException("Invalid Date format");
		}
		return stringDate;
	}

	public static String dateToStringTimeZone(Date date, String format) {
		String stringDate = "";
		try {
			if (date != null) {
				SimpleDateFormat sdf = new SimpleDateFormat(format);
				sdf.setTimeZone(TimeZone.getTimeZone("EST"));
				stringDate = sdf.format(date);
			}
		} catch (Exception e) {
			throw new RuntimeException("Invalid Date format");
		}
		return stringDate;
	}
	
	public static void main(String[] args) {
		System.out.println(WebUtility.dateToStringTimeZone(new Date(), "MM/dd/yyyy"));
		System.out.println(WebUtility.dateToString(new Date(), "MM/dd/yyyy"));
		System.out.println(String.valueOf(new Integer(10)));
	}
}
